/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/************************************************************************/
/* File seq_lex.h                                                       */
/* defines all token indices to be passed from yylex to yacc            */
/************************************************************************/

#ifndef _SEQ_LEX_H_
#define _SEQ_LEX_H_

#define INPUT_VAR  257
#define INPUT_VAR_VECTOR 258
#define CONST_VECTOR  259
#define DECIMAL_NUM  260
#define TRANSIENT_INSTANCE_NAME 261
#define TRANSIENT_STATE  262
#define TRANSIENT_NEXTSTATE 263
#define TRANSIENT_XCOND  264
#define TRANSIENT_OUTPUT 265
#define TRANSIENT_OUTPUT_VECTOR 266
#define LOGICAL_AND             267
#define LOGICAL_OR              268
#define LOGICAL_NOT             269
#define LOGICAL_XOR             270
#define UNDEF_TOKEN             300

typedef struct { char * name;
                 int defined_as;
               } keyword;

#define SEQ_KEYWORDS  3

const keyword seq_keyword_list[] = {
{ "state",     TRANSIENT_STATE },
{ "nextstate", TRANSIENT_NEXTSTATE },
{ "xcond",     TRANSIENT_XCOND }};

/* function prototypes */

int yyerror(char *);
int yylex();
int string_to_bin(char *);
int string_to_dec(char *);

#endif

